CONTAINER TextureProjection
{
    NAME TextureProjection;
    INCLUDE Mbase;

    GROUP TEX_PROJ_SHADER_GRP
    {
        DEFAULT 1; SCALE_V; SCALE_H;

        GROUP TEX_PROJ_TYPE_GROUP
        {
            LONG TEX_PROJECTION_TYPE
            {
                CYCLE
                {
                    TEX_PROJ_BOX;
                    TEX_PROJ_CYLINDRICAL;
                    TEX_PROJ_MESHUV;
                    TEX_PROJ_OSL_PROJECTION;
                    TEX_PROJ_OSL_UV;
                    TEX_PROJ_PERSPECTIVE;
                    TEX_PROJ_SPHERICAL;
                    TEX_PROJ_TRIPLANAR;
                    TEX_PROJ_XYZ_TO_UVW;
                }
            }
        }

        LONG UVW_SET { MIN 1; MAX 3; }

        GROUP TEX_PROJ_POS_GROUP
        {
            LONG PROJ_POS_TYPE
            {
                CYCLE
                {
                    TEX_PROJ_POS_WORLD;
                    TEX_PROJ_POS_OBJECT;
                    TEX_PROJ_POS_NORMAL;
                }
            }
        }

        GROUP TEXPROJ_OSL_MAIN_GRP
        {
            OPEN; DEFAULT 1;
            SCALE_V; SCALE_H;

            GROUP TEXPROJ_OSL_SCRIPTS_GRP
            {
                COLUMNS 2;
            }

            GROUP TEXPROJ_OSL_EDITOR_GRP
            {
                OPEN; SCALE_V; SCALE_H;
                GROUP TEXPROJ_OSL_BUTTON_GRP
                {
                    COLUMNS 4;
                    BUTTON TEXPROJ_OSL_OPEN_CODE_DLG {}
                    BUTTON TEXPROJ_OSL_COMPILE_BTN {}
                    BOOL TEXPROJ_OSL_AUTO_COMPILE {}
                }
                STRING TEXPROJ_OSL_CODE_EDITOR { ANIM OFF; CUSTOMGUI MULTISTRING; SCALE_H; SCALE_V; WORDWRAP; PYTHON; }
                STRING TEXPROJ_OSL_LOG_OUTPUT  { ANIM OFF; CUSTOMGUI MULTISTRING; SCALE_H; WORDWRAP; }
            }
            GROUP TEXPROJ_OSL_PARAMS_GRP
            {
                OPEN; DEFAULT 1;
            }
        }

        GROUP TRANSFORM1_GROUP
        {
            OPEN;DEFAULT 1;

            SHADERLINK PROJ_TRANS1_LINK { OPEN; ACCEPT {Transform; }; }

            BUTTON TEX_PROJ_RESET_BTN     {}

            LINK TEX_PROJ_OBJECT_LINK {   OPEN; }

            GROUP INTERNAL_TRANSFORM1_GRP
            {
                OPEN;DEFAULT 1;

                GROUP
                {
                    COLUMNS 1;

                    LONG PROJ_TRANS1_TYPE
                    {
                        CYCLE
                        {
                            TRNS_2D_TRANSFORMATION;
                            TRNS_3D_ROTATION;
                            TRNS_3D_SCALE;
                            TRNS_3D_TRANSFORMATION;
                            TRNS_TRANSFORM_VALUE;
                        }
                    }

                    LONG TEXPROJ_ROT_ORDER
                    {
                        CYCLE
                        {
                            TEXPROJ_ROT_ORDER_XYZ;
                            TEXPROJ_ROT_ORDER_XZY;
                            TEXPROJ_ROT_ORDER_YXZ;
                            TEXPROJ_ROT_ORDER_YZX;
                            TEXPROJ_ROT_ORDER_ZXY;
                            TEXPROJ_ROT_ORDER_ZYX;
                        }
                    }
                }
                OPEN;

                GROUP TEX_PROJ_ROT_GRP
                {
                    REAL   TEX_PROJ_TRANS_RX1 { CUSTOMGUI OCTNSLIDER; LOGARITMIC 0; UNIT REAL;  STEP 0.1; MIN -360; MAX 360.0; MINSLIDER -360;  MAXSLIDER 360; }
                    REAL   TEX_PROJ_TRANS_RY1 { CUSTOMGUI OCTNSLIDER; LOGARITMIC 0; UNIT REAL;  STEP 0.1; MIN -360; MAX 360.0; MINSLIDER -360;  MAXSLIDER 360; }
                    REAL   TEX_PROJ_TRANS_RZ1 { CUSTOMGUI OCTNSLIDER; LOGARITMIC 0; UNIT REAL;  STEP 0.1; MIN -360; MAX 360.0; MINSLIDER -360;  MAXSLIDER 360; }
                }

                GROUP TEX_PROJ_SCL_GRP
                {
                    BOOL TEX_PROJ_SCL_LOCK {};
                    GROUP
                    {
                    REAL   TEX_PROJ_TRANS_SX1 { CUSTOMGUI OCTNSLIDER; LOGARITMIC 1; UNIT REAL;  STEP 0.1; MIN -1000; MAX 1000.0; MINSLIDER 0.00010;  MAXSLIDER 10; }
                    REAL   TEX_PROJ_TRANS_SY1 { CUSTOMGUI OCTNSLIDER; LOGARITMIC 1; UNIT REAL;  STEP 0.1; MIN -1000; MAX 1000.0; MINSLIDER 0.00010;  MAXSLIDER 10; }
                    REAL   TEX_PROJ_TRANS_SZ1 { CUSTOMGUI OCTNSLIDER; LOGARITMIC 1; UNIT REAL;  STEP 0.1; MIN -1000; MAX 1000.0; MINSLIDER 0.00010;  MAXSLIDER 10; }
                    }
                }
                SEPARATOR {}

                GROUP TEX_PROJ_POS_GRP
                {
                    REAL   TEX_PROJ_TRANS_TX1 { CUSTOMGUI OCTNSLIDER; LOGARITMIC 0; UNIT REAL;  STEP 0.1; MIN -1000000; MAX 1000000.0; MINSLIDER -1;  MAXSLIDER 1; }
                    REAL   TEX_PROJ_TRANS_TY1 { CUSTOMGUI OCTNSLIDER; LOGARITMIC 0; UNIT REAL;  STEP 0.1; MIN -1000000; MAX 1000000.0; MINSLIDER -1;  MAXSLIDER 1; }
                    REAL   TEX_PROJ_TRANS_TZ1 { CUSTOMGUI OCTNSLIDER; LOGARITMIC 0; UNIT REAL;  STEP 0.1; MIN -1000000; MAX 1000000.0; MINSLIDER -1;  MAXSLIDER 1; }
                }
            }
        }
        //BOOL TEX_PROJ_NGVISIBLE {};
    }
    GROUP
    {
        SEPARATOR { LINE; }
        BITMAPBUTTON  TEXPROJ_HELP_BTN {ANIM OFF;}
    }
}
